<?php

/**
 * Фасад для роботи з логуванням (алиас для Log)
 *
 * @package Flowaxy\Support\Facades
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Core\Contracts\LoggerInterface;
use Flowaxy\Infrastructure\Logging\Logger as LoggerInstance;

final class Logger extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return LoggerInterface::class;
    }

    /**
     * Отримання екземпляра Logger
     */
    public static function instance(): LoggerInstance
    {
        $container = static::getContainer();
        if ($container->has(LoggerInterface::class)) {
            return $container->make(LoggerInterface::class);
        }

        // Fallback на getInstance
        return LoggerInstance::getInstance();
    }

    /**
     * Логування повідомлення
     *
     * @param int $level
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function log(int $level, string $message, array $context = []): void
    {
        static::instance()->log($level, $message, $context);
    }

    /**
     * Логування помилки
     *
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function error(string $message, array $context = []): void
    {
        static::instance()->logError($message, $context);
    }

    /**
     * Логування попередження
     *
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function warning(string $message, array $context = []): void
    {
        static::instance()->logWarning($message, $context);
    }

    /**
     * Логування інформації
     *
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function info(string $message, array $context = []): void
    {
        static::instance()->logInfo($message, $context);
    }

    /**
     * Логування відлагоджувальної інформації
     *
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function debug(string $message, array $context = []): void
    {
        static::instance()->logDebug($message, $context);
    }

    /**
     * Логування критичної помилки
     *
     * @param string $message
     * @param array<string, mixed> $context
     * @return void
     */
    public static function critical(string $message, array $context = []): void
    {
        static::instance()->logCritical($message, $context);
    }
}
