<?php

/**
 * Фасад для роботи з шифруванням
 *
 * @package Flowaxy\Support\Facades
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Infrastructure\Security\Encryption as EncryptionInstance;

final class Encryption extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return EncryptionInstance::class;
    }

    /**
     * Отримати екземпляр Encryption
     *
     * @return EncryptionInstance
     */
    private static function encryption(): EncryptionInstance
    {
        return static::getFacadeRoot();
    }

    /**
     * Зашифрувати значення
     *
     * @param string $value
     * @param string|null $key
     * @return string
     */
    public static function encrypt(string $value, ?string $key = null): string
    {
        return EncryptionInstance::quickEncrypt($value, $key);
    }

    /**
     * Розшифрувати значення
     *
     * @param string $value
     * @param string|null $key
     * @return string
     */
    public static function decrypt(string $value, ?string $key = null): string
    {
        return EncryptionInstance::quickDecrypt($value, $key);
    }

    /**
     * Зашифрувати рядок
     *
     * @param string $value
     * @param string|null $key
     * @return string
     */
    public static function encryptString(string $value, ?string $key = null): string
    {
        return EncryptionInstance::quickEncrypt($value, $key);
    }

    /**
     * Розшифрувати рядок
     *
     * @param string $value
     * @param string|null $key
     * @return string
     */
    public static function decryptString(string $value, ?string $key = null): string
    {
        return EncryptionInstance::quickDecrypt($value, $key);
    }
}
