<?php

/**
 * Фасад для роботи з кешем
 *
 * @package Flowaxy\Support\Facades
 */

declare(strict_types=1);

namespace Flowaxy\Support\Facades;

use Flowaxy\Infrastructure\Cache\Cache as CacheInstance;

final class Cache extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return 'Cache';
    }

    /**
     * Отримання екземпляра Cache
     *
     * @return CacheInstance
     */
    public static function instance(): CacheInstance
    {
        return static::getFacadeRoot();
    }

    /**
     * Отримання значення з кешу
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public static function get(string $key, mixed $default = null): mixed
    {
        return static::getFacadeRoot()->get($key, $default);
    }

    /**
     * Збереження значення в кеш
     *
     * @param string $key
     * @param mixed $value
     * @param int|null $ttl
     * @return bool
     */
    public static function set(string $key, mixed $value, ?int $ttl = null): bool
    {
        return static::getFacadeRoot()->set($key, $value, $ttl);
    }

    /**
     * Видалення значення з кешу
     *
     * @param string $key
     * @return bool
     */
    public static function delete(string $key): bool
    {
        return static::getFacadeRoot()->delete($key);
    }

    /**
     * Очищення кешу
     *
     * @return bool
     */
    public static function clear(): bool
    {
        return static::getFacadeRoot()->clear();
    }
}
