<?php

declare(strict_types=1);

namespace Flowaxy\Support\Base;

use Flowaxy\Contracts\Service\ServiceInterface;
use Flowaxy\Contracts\Service\LifecycleInterface;

// Базовый класс для сервисов Flowaxy CMS
// Предоставляет общую функциональность для всех сервисов
abstract class BaseService implements ServiceInterface, LifecycleInterface
{
    // Инициализация сервиса
    public function init(): void
    {
        // Переопределяется в дочерних классах
    }

    // Запуск сервиса
    public function boot(): void
    {
        // Переопределяется в дочерних классах
    }

    // Остановка сервиса
    public function shutdown(): void
    {
        // Переопределяется в дочерних классах
    }

    // Получение имени сервиса
    public function getName(): string
    {
        return static::class;
    }
}
