<?php

/**
 * Действие деактивации плагина
 *
 * @package Flowaxy\Support\Actions\Plugin
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Support\Actions\Plugin;

use Flowaxy\Support\Actions\ActionInterface;
use Flowaxy\Support\Services\PluginService;
use Flowaxy\Support\Facades\Log;
use Exception;
use Throwable;

final class DeactivatePluginAction implements ActionInterface
{
    private PluginService $pluginService;

    public function __construct()
    {
        $this->pluginService = new PluginService();
    }

    public function execute(array $params = []): array
    {
        $pluginSlug = $params['plugin_slug'] ?? '';

        if (empty($pluginSlug)) {
            return [
                'success' => false,
                'error' => 'Slug плагіна не вказано',
            ];
        }

        try {
            $result = $this->pluginService->deactivate($pluginSlug);

            if ($result) {
                return [
                    'success' => true,
                    'message' => 'Плагін деактивовано',
                    'data' => ['plugin_slug' => $pluginSlug],
                ];
            }

            return [
                'success' => false,
                'error' => 'Не вдалося деактивувати плагін',
            ];
        } catch (Throwable $e) {
            try {
                Log::Error('Помилка деактивації плагіна', ['exception' => $e, 'plugin_slug' => $pluginSlug]);
            } catch (Throwable $logError) {
                // Ignore logging errors
            }
            return [
                'success' => false,
                'error' => $e->getMessage(),
            ];
        }
    }

    public function validate(array $params): array
    {
        if (empty($params['plugin_slug'])) {
            return [
                'valid' => false,
                'error' => 'Slug плагіна обов\'язковий',
            ];
        }

        return ['valid' => true];
    }

    public function getName(): string
    {
        return 'deactivate_plugin';
    }

    public function getDescription(): string
    {
        return 'Деактивація плагіна';
    }
}
