<?php

declare(strict_types=1);

namespace Flowaxy\Support\Actions;

// Интерфейс для действий
// Паттерн Command для обработки действий
interface ActionInterface
{
    // Выполнение действия
    public function execute(array $params = []): array;

    // Валидация параметров перед выполнением
    public function validate(array $params): array;

    // Получение имени действия
    public function getName(): string;

    // Получение описания действия
    public function getDescription(): string;
}
