<?php

/**
 * Клас для роботи з консоллю
 *
 * @package Flowaxy\Interface\CLI
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Interface\CLI;

final class Console
{
    /**
     * @var array<string, CommandInterface>
     */
    private static array $commands = [];

    /**
     * Реєстрація команди
     *
     * @param CommandInterface $command
     * @return void
     */
    public static function register(CommandInterface $command): void
    {
        self::$commands[$command->getName()] = $command;
    }

    /**
     * Виконання команди
     *
     * @param string $name Назва команди
     * @param array<string> $args Аргументи
     * @return int Код виходу
     */
    public static function run(string $name, array $args = []): int
    {
        if (!isset(self::$commands[$name])) {
            echo "Command '{$name}' not found.\n";
            echo "Available commands:\n";
            foreach (self::$commands as $cmdName => $cmd) {
                echo "  - {$cmdName}: {$cmd->getDescription()}\n";
            }
            return 1;
        }

        return self::$commands[$name]->execute($args);
    }

    /**
     * Отримати список команд
     *
     * @return array<string, CommandInterface>
     */
    public static function getCommands(): array
    {
        return self::$commands;
    }

    /**
     * Отримати команду за назвою
     *
     * @param string $name
     * @return CommandInterface|null
     */
    public static function getCommand(string $name): ?CommandInterface
    {
        return self::$commands[$name] ?? null;
    }
}
