<?php

/**
 * Інтерфейс для CLI команд
 *
 * @package Flowaxy\Interface\CLI
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Interface\CLI;

interface CommandInterface
{
    /**
     * Виконання команди
     *
     * @param array<string> $args Аргументи командного рядка
     * @return int Код виходу (0 = успіх)
     */
    public function execute(array $args): int;

    /**
     * Отримати назву команди
     *
     * @return string
     */
    public function getName(): string;

    /**
     * Отримати опис команди
     *
     * @return string
     */
    public function getDescription(): string;

    /**
     * Отримати довідку по команді
     *
     * @return string
     */
    public function getHelp(): string;
}
