<?php

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Security;

use Flowaxy\Contracts\Security\PluginCapabilityInterface;

/**
 * Gate для проверки capabilities при выполнении действий
 *
 * @package Flowaxy\Infrastructure\Security
 */
final class PluginGate
{
    public function __construct(
        private readonly PluginCapabilityInterface $capabilityChecker
    ) {
    }

    /**
     * Проверить capability перед выполнением действия
     *
     * @param string $pluginSlug Slug плагина
     * @param string $capability Название capability
     * @return bool
     */
    public function allows(string $pluginSlug, string $capability): bool
    {
        return $this->capabilityChecker->hasCapability($pluginSlug, $capability);
    }

    /**
     * Проверить capability перед выполнением действия (alias для allows)
     *
     * @param string $pluginSlug Slug плагина
     * @param string $capability Название capability
     * @return bool
     */
    public function denies(string $pluginSlug, string $capability): bool
    {
        return !$this->allows($pluginSlug, $capability);
    }
}
