<?php

/**
 * Базовый интерфейс для репозиториев
 *
 * @package Flowaxy\Infrastructure\Persistence\Repositories
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Persistence\Repositories;

interface RepositoryInterface
{
    /**
     * Получить все записи
     *
     * @return array<int, object>
     */
    public function all(): array;

    /**
     * Найти запись по идентификатору
     *
     * @param string|int $id
     * @return object|null
     */
    public function find($id): ?object;

    /**
     * Сохранить запись
     *
     * @param object $entity
     * @return bool
     */
    public function save(object $entity): bool;

    /**
     * Удалить запись
     *
     * @param string|int $id
     * @return bool
     */
    public function delete($id): bool;
}
