<?php

/**
 * Інтерфейс для відправки email
 *
 * @package Flowaxy\Infrastructure\Mail
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Mail;

interface MailerInterface
{
    /**
     * Відправка повідомлення
     *
     * @param Message $message
     * @return bool
     */
    public function send(Message $message): bool;

    /**
     * Створити нове повідомлення
     *
     * @return Message
     */
    public function createMessage(): Message;
}
