<?php

/**
 * Клас для відправки email через Mailer
 *
 * @package Flowaxy\Infrastructure\Mail
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Mail;

final class Mailer implements MailerInterface
{
    /**
     * Відправка повідомлення
     *
     * @param Message $message
     * @return bool
     */
    public function send(Message $message): bool
    {
        // Используем существующий класс Mail для отправки
        $mail = new Mail(
            $message->getTo(),
            $message->getSubject(),
            $message->getBody()
        );

        if ($message->getFrom() !== null) {
            $mail->from($message->getFrom(), $message->getFromName());
        }

        foreach ($message->getHeaders() as $name => $value) {
            $mail->header($name, $value);
        }

        foreach ($message->getAttachments() as $attachment) {
            $mail->attach($attachment['path'], $attachment['name'] ?? null);
        }

        $mail->isHtml($message->isHtml());

        return $mail->send();
    }

    /**
     * Створити нове повідомлення
     *
     * @return Message
     */
    public function createMessage(): Message
    {
        return new Message();
    }
}
