<?php

/**
 * Уровни логирования
 *
 * @package Flowaxy\Infrastructure\Logging
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Logging;

enum LogLevel: int
{
    case DEBUG = 0;
    case INFO = 1;
    case WARNING = 2;
    case ERROR = 3;
    case CRITICAL = 4;

    /**
     * Получить название уровня
     *
     * @return string
     */
    public function getName(): string
    {
        return match($this) {
            self::DEBUG => 'DEBUG',
            self::INFO => 'INFO',
            self::WARNING => 'WARNING',
            self::ERROR => 'ERROR',
            self::CRITICAL => 'CRITICAL',
        };
    }

    /**
     * Получить уровень по названию
     *
     * @param string $name
     * @return self|null
     */
    public static function fromName(string $name): ?self
    {
        return match(strtoupper($name)) {
            'DEBUG' => self::DEBUG,
            'INFO' => self::INFO,
            'WARNING' => self::WARNING,
            'ERROR' => self::ERROR,
            'CRITICAL' => self::CRITICAL,
            default => null,
        };
    }
}
