<?php

/**
 * Интерфейс форматтера логов
 *
 * @package Flowaxy\Infrastructure\Logging\Formatters
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Logging\Formatters;

interface LogFormatterInterface
{
    /**
     * Форматировать запись лога
     *
     * @param string $level Уровень лога
     * @param string $message Сообщение
     * @param array<string, mixed> $context Контекст
     * @return string
     */
    public function format(string $level, string $message, array $context = []): string;
}
