<?php

/**
 * JSON форматтер логов
 *
 * @package Flowaxy\Infrastructure\Logging\Formatters
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Logging\Formatters;

class JsonLogFormatter implements LogFormatterInterface
{
    public function format(string $level, string $message, array $context = []): string
    {
        $log = [
            'timestamp' => date('Y-m-d H:i:s'),
            'level' => $level,
            'message' => $message,
            'context' => $context,
        ];

        return json_encode($log, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
}
