<?php

/**
 * Інтерфейс для структурованих файлів (JSON, YAML, INI, XML)
 *
 * @package Flowaxy\Infrastructure\Filesystem
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Filesystem;

interface StructuredFileInterface
{
    /**
     * Читання структурованого файлу
     *
     * @param string $filePath Шлях до файлу
     * @return array<string, mixed>|null
     */
    public function read(string $filePath): ?array;

    /**
     * Запис структурованого файлу
     *
     * @param string $filePath Шлях до файлу
     * @param array<string, mixed> $data Дані для запису
     * @return bool
     */
    public function write(string $filePath, array $data): bool;

    /**
     * Отримати значення за ключем
     *
     * @param string $filePath Шлях до файлу
     * @param string $key Ключ (може бути в форматі "section.key")
     * @param mixed $default Значення за замовчуванням
     * @return mixed
     */
    public function get(string $filePath, string $key, $default = null);

    /**
     * Встановити значення за ключем
     *
     * @param string $filePath Шлях до файлу
     * @param string $key Ключ (може бути в форматі "section.key")
     * @param mixed $value Значення
     * @return bool
     */
    public function set(string $filePath, string $key, $value): bool;

    /**
     * Видалити значення за ключем
     *
     * @param string $filePath Шлях до файлу
     * @param string $key Ключ
     * @return bool
     */
    public function remove(string $filePath, string $key): bool;
}
