<?php

/**
 * Інтерфейс для системи зберігання файлів
 *
 * @package Flowaxy\Infrastructure\Filesystem
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Filesystem;

interface StorageInterface
{
    /**
     * Зберегти файл
     *
     * @param string $path Шлях для збереження
     * @param string $content Вміст файлу
     * @return bool
     */
    public function put(string $path, string $content): bool;

    /**
     * Отримати вміст файлу
     *
     * @param string $path Шлях до файлу
     * @return string|false
     */
    public function get(string $path): string|false;

    /**
     * Перевірити існування файлу
     *
     * @param string $path Шлях до файлу
     * @return bool
     */
    public function exists(string $path): bool;

    /**
     * Видалити файл
     *
     * @param string $path Шлях до файлу
     * @return bool
     */
    public function delete(string $path): bool;

    /**
     * Отримати розмір файлу
     *
     * @param string $path Шлях до файлу
     * @return int|false
     */
    public function size(string $path): int|false;

    /**
     * Отримати час останньої модифікації
     *
     * @param string $path Шлях до файлу
     * @return int|false
     */
    public function lastModified(string $path): int|false;

    /**
     * Отримати список файлів у директорії
     *
     * @param string $path Шлях до директорії
     * @return array<int, string>
     */
    public function files(string $path): array;

    /**
     * Отримати список директорій
     *
     * @param string $path Шлях до директорії
     * @return array<int, string>
     */
    public function directories(string $path): array;
}
