<?php

/**
 * Загрузчик PHP конфигурации
 *
 * @package Flowaxy\Infrastructure\Config\Loaders
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Config\Loaders;

use Flowaxy\Support\Helpers\FileHelper;

class PhpConfigLoader implements ConfigLoaderInterface
{
    public function load(string $path): array
    {
        if (!FileHelper::exists($path) || !FileHelper::isReadable($path)) {
            return [];
        }

        $config = require $path;
        return is_array($config) ? $config : [];
    }

    public function supports(string $path): bool
    {
        return str_ends_with($path, '.php');
    }
}
