<?php

/**
 * Загрузчик JSON конфигурации
 *
 * @package Flowaxy\Infrastructure\Config\Loaders
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Config\Loaders;

use Flowaxy\Support\Helpers\FileHelper;
use Flowaxy\Support\Helpers\JsonHelper;

class JsonConfigLoader implements ConfigLoaderInterface
{
    public function load(string $path): array
    {
        if (!FileHelper::exists($path) || !FileHelper::isReadable($path)) {
            return [];
        }

        $config = JsonHelper::readFile($path, true);
        return is_array($config) ? $config : [];
    }

    public function supports(string $path): bool
    {
        return str_ends_with($path, '.json');
    }
}
