<?php

/**
 * Интерфейс загрузчика конфигурации
 *
 * @package Flowaxy\Infrastructure\Config\Loaders
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Config\Loaders;

interface ConfigLoaderInterface
{
    /**
     * Загрузить конфигурацию из файла
     *
     * @param string $path Путь к файлу конфигурации
     * @return array<string, mixed>
     */
    public function load(string $path): array;

    /**
     * Проверить, поддерживается ли формат файла
     *
     * @param string $path Путь к файлу
     * @return bool
     */
    public function supports(string $path): bool;
}
