<?php

/**
 * Інтерфейс для роботи з конфігураціями
 *
 * @package Flowaxy\Infrastructure\Config
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Config;

interface ConfigInterface
{
    /**
     * Отримати значення конфігурації
     *
     * @param string $key Ключ конфігурації
     * @param mixed $default Значення за замовчуванням
     * @return mixed
     */
    public function get(string $key, $default = null);

    /**
     * Встановити значення конфігурації
     *
     * @param string $key Ключ конфігурації
     * @param mixed $value Значення
     * @return bool
     */
    public function set(string $key, $value): bool;

    /**
     * Перевірити існування ключа
     *
     * @param string $key Ключ конфігурації
     * @return bool
     */
    public function has(string $key): bool;

    /**
     * Видалити ключ
     *
     * @param string $key Ключ конфігурації
     * @return bool
     */
    public function remove(string $key): bool;

    /**
     * Отримати всі конфігурації
     *
     * @return array<string, mixed>
     */
    public function all(): array;
}
