<?php

/**
 * Cache Warmer для маршрутов
 *
 * @package Flowaxy\Infrastructure\Cache\Warmers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Cache\Warmers;

use Flowaxy\Core\Routing\Router;
use Flowaxy\Support\Facades\Log;

final class RoutesCacheWarmer implements CacheWarmerInterface
{
    public function warm(): void
    {
        try {
            // Загружаем маршруты через RouterLoader
            $routerLoaderFile = \Flowaxy\Core\System\PathResolver::bootstrap() . DS . 'RouterLoader.php';
            if (file_exists($routerLoaderFile)) {
                require_once $routerLoaderFile;
                \Flowaxy\Bootstrap\RouterLoader::load();
            }

            Log::Info('RoutesCacheWarmer: Routes cache warmed');
        } catch (\Throwable $e) {
            Log::Error('RoutesCacheWarmer::warm error: ' . $e->getMessage());
        }
    }

    public function isOptional(): bool
    {
        return true;
    }
}
