<?php

/**
 * Cache Warmer для конфигураций
 *
 * @package Flowaxy\Infrastructure\Cache\Warmers
 * @version 1.0.0 Alpha prerelease
 */

declare(strict_types=1);

namespace Flowaxy\Infrastructure\Cache\Warmers;

use Flowaxy\Infrastructure\Cache\Cache;
use Flowaxy\Infrastructure\Config\Config;
use Flowaxy\Support\Facades\Log;

final class ConfigCacheWarmer implements CacheWarmerInterface
{
    public function warm(): void
    {
        try {
            $config = Config::getInstance();
            $configDir = \Flowaxy\Core\System\PathResolver::storageConfig();

            // Загружаем все конфигурационные файлы (INI и JSON)
            $files = array_merge(
                glob($configDir . DS . '*.ini') ?: [],
                glob($configDir . DS . '*.json') ?: []
            );

            foreach ($files as $file) {
                $configName = basename($file, pathinfo($file, PATHINFO_EXTENSION));
                $configName = rtrim($configName, '.');
                // Загружаем конфигурацию, что автоматически кеширует её
                $extension = pathinfo($file, PATHINFO_EXTENSION);
                $config->get($configName, null, '.' . $extension);
            }

            Log::Info('ConfigCacheWarmer: Configuration cache warmed');
        } catch (\Throwable $e) {
            Log::Error('ConfigCacheWarmer::warm error: ' . $e->getMessage());
        }
    }

    public function isOptional(): bool
    {
        return false;
    }
}
