<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\ValueObjects;

use InvalidArgumentException;

// Value Object для ID користувача
class UserId
{
    public function __construct(
        private readonly int $value,
    ) {
        if ($value <= 0) {
            throw new InvalidArgumentException('User ID must be positive');
        }
    }

    public function getValue(): int
    {
        return $this->value;
    }

    public function equals(UserId $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return (string) $this->value;
    }
}
