<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\ValueObjects;

use InvalidArgumentException;

use function filter_var;
use const FILTER_VALIDATE_EMAIL;

// Value Object для email
class Email
{
    public function __construct(
        private readonly string $value,
    ) {
        if (empty($value) || !filter_var($value, FILTER_VALIDATE_EMAIL)) {
            throw new InvalidArgumentException("Invalid email: {$value}");
        }
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function equals(Email $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
