<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Domain\User\Entities\User;

// Інтерфейс репозиторію користувачів (локальний аліас для зворотної сумісності)
interface UserRepositoryInterface extends \Flowaxy\Contracts\Domain\User\UserRepositoryInterface
{
    public function findByUsername(string $username): ?User;

    public function updateSession(int $userId, string $token, string $lastActivity): bool;

    public function clearSession(int $userId): bool;

    public function markInactive(int $userId): bool;

    public function updateLastActivity(int $userId, string $timestamp): bool;
}
