<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Domain\User\Entities\Role;

// Інтерфейс репозиторію ролей (локальний аліас для зворотної сумісності)
interface RoleRepositoryInterface extends \Flowaxy\Contracts\Domain\User\RoleRepositoryInterface
{
    public function getRolesForUser(int $userId): array;

    public function getPermissionsForUser(int $userId): array;

    public function userHasRole(int $userId, string $roleSlug): bool;

    public function userHasPermission(int $userId, string $permission): bool;

    public function assignRole(int $userId, int $roleId): bool;

    public function removeRole(int $userId, int $roleId): bool;
}
