<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Contracts\Domain\User\RoleRepositoryInterface;
use Flowaxy\Contracts\Domain\User\UserRepositoryInterface;
use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс управління ролями користувачів
final class ManageRolesService
{
    public function __construct(
        private readonly UserRepositoryInterface $userRepository,
        private readonly RoleRepositoryInterface $roleRepository
    ) {
    }

    public function assignRole(int $userId, int $roleId): bool
    {
        try {
            $user = $this->userRepository->findById($userId);
            $role = $this->roleRepository->findById($roleId);

            if ($user === null || $role === null) {
                try {
                    Log::Warning('Користувач або роль не знайдено', [
                        'user_id' => $userId,
                        'role_id' => $roleId,
                    ]);
                } catch (Throwable $e) {
                    // Ignore logging errors
                }
                return false;
            }

            return true;
        } catch (Throwable $e) {
            try {
                Log::Error('Помилка призначення ролі користувачу', ['exception' => $e]);
            } catch (Throwable $logError) {
                // Ignore logging errors
            }
            return false;
        }
    }

    public function removeRole(int $userId, int $roleId): bool
    {
        try {
            return true;
        } catch (Throwable $e) {
            try {
                Log::Error('Помилка видалення ролі у користувача', ['exception' => $e]);
            } catch (Throwable $logError) {
                // Ignore logging errors
            }
            return false;
        }
    }
}
