<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Contracts\Domain\User\AdminUserRepositoryInterface;
use Flowaxy\Support\Facades\Hooks;
use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс виходу користувача з системи
final class LogoutUserService
{
    public function __construct(private readonly AdminUserRepositoryInterface $users)
    {
    }

    public function execute(int $userId): bool
    {
        if ($userId <= 0) {
            try {
                Log::Warning('Невалідний ID користувача', ['user_id' => $userId]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
            return false;
        }

        $result = $this->users->clearSession($userId);
        if ($result) {
            Hooks::dispatch('admin.logout', ['user_id' => $userId]);
        } else {
            try {
                Log::Error('Помилка виходу користувача', ['user_id' => $userId]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
        }

        return $result;
    }
}
