<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Domain\User\Entities\AdminUser;

// Аліас для зворотної сумісності - використовуйте UserRepositoryInterface замість AdminUserRepositoryInterface
interface AdminUserRepositoryInterface extends \Flowaxy\Contracts\Domain\User\AdminUserRepositoryInterface
{
    public function updateSession(int $userId, string $token, string $lastActivity): bool;

    public function clearSession(int $userId): bool;

    public function markInactive(int $userId): bool;

    public function updateLastActivity(int $userId, string $timestamp): bool;
}
