<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Services;

use Flowaxy\Domain\User\Entities\AdminRole;

// Аліас для зворотної сумісності - використовуйте RoleRepositoryInterface замість AdminRoleRepositoryInterface
interface AdminRoleRepositoryInterface extends \Flowaxy\Contracts\Domain\User\AdminRoleRepositoryInterface
{
    public function getRolesForUser(int $userId): array;

    public function getPermissionsForUser(int $userId): array;

    public function userHasRole(int $userId, string $roleSlug): bool;

    public function userHasPermission(int $userId, string $permission): bool;

    public function assignRole(int $userId, int $roleId): bool;

    public function removeRole(int $userId, int $roleId): bool;
}
