<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Events;

use DateTimeImmutable;
use Flowaxy\Domain\Events\DomainEventInterface;

// Подія створення користувача
final class UserCreatedEvent implements DomainEventInterface
{
    private DateTimeImmutable $occurredAt;

    public function __construct(
        private readonly int $userId,
        private readonly string $username,
        private readonly string $email
    ) {
        $this->occurredAt = new DateTimeImmutable();
    }

    public function occurredAt(): DateTimeImmutable
    {
        return $this->occurredAt;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getPayload(): array
    {
        return [
            'user_id' => $this->userId,
            'username' => $this->username,
            'email' => $this->email,
        ];
    }
}
