<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\Entities;

// Аліас для зворотної сумісності - використовуйте User замість AdminUser
final class AdminUser
{
    public function __construct(
        public readonly int $id,
        public readonly string $username,
        public readonly string $passwordHash,
        public ?string $sessionToken,
        public ?string $lastActivity,
        public bool $isActive
    ) {
    }

    // Створює AdminUser з User
    public static function fromUser(User $user): self
    {
        return new self(
            id: $user->id,
            username: $user->username,
            passwordHash: $user->passwordHash,
            sessionToken: $user->sessionToken,
            lastActivity: $user->lastActivity,
            isActive: $user->isActive
        );
    }

    // Конвертує AdminUser в User
    public function toUser(): User
    {
        return new User(
            id: $this->id,
            username: $this->username,
            passwordHash: $this->passwordHash,
            sessionToken: $this->sessionToken,
            lastActivity: $this->lastActivity,
            isActive: $this->isActive
        );
    }
}
