<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\DTOs;

// DTO для користувача
class UserDTO
{
    public function __construct(
        public readonly ?int $id,
        public readonly string $email,
        public readonly string $username,
        public readonly ?string $name = null,
        public readonly ?int $roleId = null,
        public readonly ?string $createdAt = null,
        public readonly ?string $updatedAt = null,
    ) {
    }

    public function toArray(): array
    {
        return [
            'id' => $this->id,
            'email' => $this->email,
            'username' => $this->username,
            'name' => $this->name,
            'role_id' => $this->roleId,
            'created_at' => $this->createdAt,
            'updated_at' => $this->updatedAt,
        ];
    }
}
