<?php

declare(strict_types=1);

namespace Flowaxy\Domain\User\DTOs;

// DTO для реєстрації користувача
class RegisterUserDTO
{
    public function __construct(
        public readonly string $email,
        public readonly string $username,
        public readonly string $password,
        public readonly ?string $name = null,
        public readonly ?int $roleId = null,
    ) {
    }

    public function toArray(): array
    {
        return [
            'email' => $this->email,
            'username' => $this->username,
            'password' => $this->password,
            'name' => $this->name,
            'role_id' => $this->roleId,
        ];
    }
}
