<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\ValueObjects;

use InvalidArgumentException;

use function preg_match;

// Value Object для версії теми
class ThemeVersion
{
    public function __construct(
        private readonly string $value,
    ) {
        if (empty($value) || !preg_match('/^\d+\.\d+\.\d+(-[a-z0-9]+)?$/', $value)) {
            throw new InvalidArgumentException("Invalid theme version: {$value}");
        }
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function equals(ThemeVersion $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
