<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\ValueObjects;

use InvalidArgumentException;

use function preg_match;

// Value Object для slug теми
class ThemeSlug
{
    public function __construct(
        private readonly string $value,
    ) {
        if (empty($value) || !preg_match('/^[a-z0-9\-_]+$/', $value)) {
            throw new InvalidArgumentException("Invalid theme slug: {$value}");
        }
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function equals(ThemeSlug $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
