<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\Services;

use Flowaxy\Contracts\Config\ConfigInterface;
use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс для роботи з налаштуваннями тем
final class ThemeSettingsService
{
    public function __construct(
        private readonly ConfigInterface $config
    ) {
    }

    public function get(string $themeSlug, string $key, mixed $default = null): mixed
    {
        return $this->config->get("theme.{$themeSlug}.{$key}", $default);
    }

    public function set(string $themeSlug, string $key, mixed $value): bool
    {
        try {
            $this->config->set("theme.{$themeSlug}.{$key}", $value);
            Log::Info('ThemeSettingsService::set: Setting saved', [
                'theme' => $themeSlug,
                'key' => $key,
            ]);
            return true;
        } catch (Throwable $e) {
            try {
                Log::Error('ThemeSettingsService::set error: ' . $e->getMessage());
            } catch (Throwable $logError) {
                // Ignore logging errors
            }
            return false;
        }
    }

    public function all(string $themeSlug): array
    {
        return $this->config->get("theme.{$themeSlug}", []) ?? [];
    }
}
