<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\Services;

// Інтерфейс репозиторію налаштувань тем (локальний аліас для зворотної сумісності)
interface ThemeSettingsRepositoryInterface extends \Flowaxy\Contracts\Domain\Theme\ThemeSettingsRepositoryInterface
{
    public function getValue(string $themeSlug, string $key, mixed $default = null): mixed;

    public function setValue(string $themeSlug, string $key, mixed $value): bool;

    public function setMany(string $themeSlug, array $settings): bool;

    public function clearCache(string $themeSlug): void;
}
