<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\Services;

use Flowaxy\Domain\Theme\Entities\Theme;

// Сервіс для роботи з темами
final class ThemeService
{
    public function __construct(
        private readonly ThemeRepositoryInterface $repository
    ) {
    }

    public function all(): array
    {
        return $this->repository->all();
    }

    public function findBySlug(string $slug): ?Theme
    {
        return $this->repository->find($slug);
    }

    public function getActive(): ?Theme
    {
        $themes = $this->all();
        foreach ($themes as $theme) {
            if ($theme->active) {
                return $theme;
            }
        }
        return null;
    }
}
