<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\Services;

use Flowaxy\Contracts\Domain\Theme\ThemeRepositoryInterface;
use Flowaxy\Domain\Events\DomainEventBridge;
use Flowaxy\Domain\Theme\Events\ThemeActivatedEvent;
use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс активації теми
final class ActivateThemeService
{
    public function __construct(private readonly ThemeRepositoryInterface $themes)
    {
    }

    public function execute(string $slug): bool
    {
        if ($slug === '') {
            try {
                Log::Warning('Невалідний slug');
            } catch (Throwable $e) {
                // Ignore logging errors
            }
            return false;
        }

        $result = $this->themes->activate($slug);

        if (!$result) {
            try {
                Log::Error('Помилка активації теми', ['slug' => $slug]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
            return false;
        }

        try {
            DomainEventBridge::dispatch(new ThemeActivatedEvent(themeSlug: $slug));
        } catch (Throwable $e) {
            // Ignore dispatch errors
        }

        return $result;
    }
}
