<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Theme\Events;

use DateTimeImmutable;
use Flowaxy\Domain\Events\DomainEventInterface;

// Подія активації теми
final class ThemeActivatedEvent implements DomainEventInterface
{
    private DateTimeImmutable $occurredAt;

    public function __construct(
        private readonly string $themeSlug
    ) {
        $this->occurredAt = new DateTimeImmutable();
    }

    public function occurredAt(): DateTimeImmutable
    {
        return $this->occurredAt;
    }

    public function getThemeSlug(): string
    {
        return $this->themeSlug;
    }

    public function getPayload(): array
    {
        return [
            'theme_slug' => $this->themeSlug,
        ];
    }
}
