<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Settings\Entities;

// Сущність налаштування
class Setting
{
    public function __construct(
        private readonly string $key,
        private mixed $value,
        private ?string $type = null,
        private ?string $group = null,
    ) {
    }

    public function getKey(): string
    {
        return $this->key;
    }

    public function getValue(): mixed
    {
        return $this->value;
    }

    public function setValue(mixed $value): void
    {
        $this->value = $value;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getGroup(): ?string
    {
        return $this->group;
    }
}
