<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Plugin\ValueObjects;

use InvalidArgumentException;

use function preg_match;

// Value Object для slug плагіна
class PluginSlug
{
    public function __construct(
        private readonly string $value,
    ) {
        if (empty($value) || !preg_match('/^[a-z0-9\-_]+$/', $value)) {
            throw new InvalidArgumentException("Invalid plugin slug: {$value}");
        }
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function equals(PluginSlug $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
