<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Plugin\Services;

use Flowaxy\Domain\Plugin\Entities\Plugin;

use function array_filter;

// Сервіс для роботи з плагінами
final class PluginService
{
    public function __construct(
        private readonly PluginRepositoryInterface $repository
    ) {
    }

    public function all(): array
    {
        return $this->repository->all();
    }

    public function findBySlug(string $slug): ?Plugin
    {
        return $this->repository->find($slug);
    }

    public function getActive(): array
    {
        return array_filter(
            $this->all(),
            fn(Plugin $plugin) => $plugin->active
        );
    }
}
