<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Plugin\Services;

use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс деактивації плагіна
final class DeactivatePluginService
{
    public function __construct(private readonly PluginRepositoryInterface $plugins)
    {
    }

    public function execute(string $slug): bool
    {
        if ($slug === '') {
            try {
                Log::Warning('Невалідний slug');
            } catch (Throwable $e) {
                // Ignore logging errors
            }
            return false;
        }

        $result = $this->plugins->deactivate($slug);

        if (!$result) {
            try {
                Log::Error('Помилка деактивації плагіна', ['slug' => $slug]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
        }

        return $result;
    }
}
