<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Plugin\Services;

use Flowaxy\Support\Facades\Log;
use Throwable;

// Сервіс активації плагіна
final class ActivatePluginService
{
    public function __construct(private readonly PluginRepositoryInterface $plugins)
    {
    }

    public function execute(string $slug): bool
    {
        try {
            Log::Debug('ActivatePluginService::execute: Activating plugin', ['slug' => $slug]);
        } catch (Throwable $e) {
            // Ignore logging errors
        }

        if ($slug === '') {
            try {
                Log::Warning('ActivatePluginService::execute: Invalid slug');
            } catch (Throwable $e) {
                // Ignore logging errors
            }
            return false;
        }

        $result = $this->plugins->activate($slug);

        if ($result) {
            try {
                Log::Info('ActivatePluginService::execute: Plugin activated successfully', ['slug' => $slug]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
        } else {
            try {
                Log::Error('ActivatePluginService::execute: Failed to activate plugin', ['slug' => $slug]);
            } catch (Throwable $e) {
                // Ignore logging errors
            }
        }

        return $result;
    }
}
