<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Plugin\Events;

use DateTimeImmutable;
use Flowaxy\Domain\Events\DomainEventInterface;

// Подія встановлення плагіна
final class PluginInstalledEvent implements DomainEventInterface
{
    private DateTimeImmutable $occurredAt;

    public function __construct(
        private readonly string $pluginSlug,
        private readonly string $version
    ) {
        $this->occurredAt = new DateTimeImmutable();
    }

    public function occurredAt(): DateTimeImmutable
    {
        return $this->occurredAt;
    }

    public function getPluginSlug(): string
    {
        return $this->pluginSlug;
    }

    public function getVersion(): string
    {
        return $this->version;
    }

    public function getPayload(): array
    {
        return [
            'plugin_slug' => $this->pluginSlug,
            'version' => $this->version,
        ];
    }
}
