<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Events;

use Flowaxy\Support\Facades\Event;
use Throwable;

// Bridge для перетворення Domain подій в Core Events
final class DomainEventBridge
{
    // Відправити доменну подію
    public static function dispatch(DomainEventInterface $event): void
    {
        try {
            Event::dispatch($event);
        } catch (Throwable $e) {
            // Ігноруємо помилки dispatch для ізоляції Domain від Core
        }
    }
}
