<?php

declare(strict_types=1);

namespace Flowaxy\Domain\Content\ValueObjects;

use InvalidArgumentException;

// Value Object для ID контенту
class ContentId
{
    public function __construct(
        private readonly int $value,
    ) {
        if ($value <= 0) {
            throw new InvalidArgumentException('Content ID must be positive');
        }
    }

    public function getValue(): int
    {
        return $this->value;
    }

    public function equals(ContentId $other): bool
    {
        return $this->value === $other->value;
    }

    public function __toString(): string
    {
        return (string) $this->value;
    }
}
